program format;  {c't/Bhrmann, 1/1990}

uses crt, formunit;

const
  seitenzahl = 2;
  {Anzahl der zu formatierenden Seiten}
  {Bei Atari-Format 80 Spuren einseitig hier}
  {seitenzahl=1 eintragen und 720 KB whlen}
  bootsek  : array[1..108] of byte =
  ($eb,$34,$90,$56,$42,32,$2d,32,$63,$27,$54,
   0,2,0,1,0,2,0,0,0,0,0,0,0,0,0,seitenzahl,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,$fa,$b8,$30,0,$8e,$d0,$bc,$fc,
   0,$fb,$e,$1f,$bb,7,0,$be,$6c,$7c,$90,$8a,
   4,$46,$3c,0,$74,8,$b4,$e,$56,$cd,$10,$5e,
   $eb,$f1,$b4,1,$cd,$16,$74,6,$b4,0,$cd,$16,
   $eb,$f4,$b4,0,$cd,$16,$33,$d2,$cd,$19);
   boottext1 : array[1..39] of char =
     #13#10'Diskette hat keine Systemdateien !'#13#10#10;

   { !!!! Boottext2 und Boottext3 mssen jeweils in einer Zeile
     !!!! stehen, damit der Compiler zufrieden ist }

   boottext2 : array[1..83] of char =
     'Um die Systemdateien zu bertragen mu die Diskette mit SYS A: behandelt werden.'#13#10#10;
   boottext3 : array[1..59] of char =
     'Bitte Diskette wechseln und weiter mit beliebiger Taste.'#13#10#10;

type
  sektor  = array[1..512] of byte;
  sekzeig = array[1..18] of ^sektor; {Max. 18 Sektoren Puffer}

var
  param             : string[3]; {Komandozeilenparameter}
  taste             : char;
  laufwerk          : string[1]; {Gewhltes Laufwerk bei Batch}
  formart           : string[4]; {Gewhltes Format bei Batch}
  verify            : string[1]; {Verify bei Batch}
  artform           : integer;   {Format als Realzahl}
  drive             : shortint;  {Formatlaufwerk}
  code              : integer;
  wahl              : shortint;  {Formatauswahl}
  art               : byte;  {Art des Laufwerks (s. Formunit)}
  verifyflag        : boolean;   {Verifizieren ?}
  batch             : boolean;   {Aufruf mit Kommandozeile ?}
  fparam            : boolean;   {Fehler bei Parametereingabe}
  puffer            : sekzeig;   {Platz fr max. 18 Sektoren}

{***********************Unterprogramme***********************}
procedure ausgang(sekzahl : byte);
var
  sek : byte;
begin
  laufwerkstabalt;
  for sek:=1 to sekzahl do dispose(puffer[sek]);
end;
{************************************************************}
procedure diskprep(sekzahl : byte; anzsek : word);
var               {Bootsektor, ROOT und FAT schreiben}
  zaehler : byte;
  anzahl  : byte;
  i       : integer;
  kopie   : integer;
  fehler  : byte;

begin
  anzahl:=formtab^[4]*2+round(formtab^[3]*32/512);
  {Sektoren FAT und ROOT}
  fillchar(puffer[1]^[1], sekzahl*512, 0); {Puffer lschen}
  for i:=1 to 108 do puffer[1]^[i]:=bootsek[i];
  puffer[1]^[14]:=formtab^[2]; {Sektoren pro Cluster}
  puffer[1]^[18]:=formtab^[3];
  puffer[1]^[19]:=0; {Anzahl der Eintrge im Hauptverzeichnis}
  puffer[1]^[20]:=lo(anzsek);
  puffer[1]^[21]:=hi(anzsek);  {Anzahl der Sektoren total}
  puffer[1]^[22]:=formtab^[1]; {Mediabyte}
  puffer[1]^[23]:=formtab^[4];
  puffer[1]^[24]:=0;         {Sektoren pro FAT}
  puffer[1]^[25]:=sekzahl;   {Sektoren pro Seite einer Spur}
  for i:=1 to 39 do puffer[1]^[i+108]:=ord(boottext1[i]);
  for i:=1 to 83 do puffer[1]^[i+147]:=ord(boottext2[i]);
  for i:=1 to 59 do puffer[1]^[i+230]:=ord(boottext3[i]);
  puffer[1]^[511]:=$55;
  puffer[1]^[512]:=$aa;    {Ende des Bootsektors}
  fehler:=readwriteverify(3, 0, 0, 1, 1, drive, puffer[1]^);
  for i:=1 to 512 do puffer[1]^[i]:=0;
  {Bootsektor in Puffer lschen}
  puffer[1]^[1]:=formtab^[1]; {Mediabyte}
  puffer[1]^[2]:=$ff;
  puffer[1]^[3]:=$ff;
  kopie:=formtab^[4]+1;
  puffer[kopie]^[1]:=formtab^[1];
  puffer[kopie]^[2]:=$ff;
  puffer[kopie]^[3]:=$ff;
  fehler:=readwriteverify(3, 0, 0, 2, sekzahl-1, drive,
                          puffer[1]^);
  dec(anzahl,sekzahl-1);
  fillchar(puffer[1]^[1], anzahl*512, 0); {Puffer lschen}
  fehler:=readwriteverify(3, 0, 1, 1, anzahl, drive,
                          puffer[1]^);
end;
{************************************************************}
procedure diskformat(wahl, spurzahl, sekzahl : byte);
                    {Diskette formatieren}
var
  spur      : byte;    {Aktuelle Spur}
  sek       : byte;    {Aktueller Sektorpuffer}
  seite     : byte;    {Aktuelle Seite}
  anzsektor : word;    {Sektoren auf Disk}
  taste     : char;    {evt. Taste bettigt}
  fehler    : byte;    {Fehler bei Diskoperationen}

begin
  if not batch then
  begin
    writeln(spurzahl*sekzahl,' KByte Format'); writeln;
    write('Bitte Diskette in Laufwerk ');
    highvideo;
    if drive=0 then write('A') else write('B');
    lowvideo;
    writeln(' einlegen, weiter mit Eingabetaste');
    repeat
      taste:=readkey;
    until (taste=#13) or (taste=#27);
    if taste=#27 then exit;
  end;
  for sek:=1 to sekzahl do new(puffer[sek]);
  schreibrate(art, wahl, drive);
  {Schreibrate fr Format setzen}
  laufwerkstabneu;        {DPB fr Format setzen}
  anzsektor:=spurzahl*sekzahl*seitenzahl;
  spur:=0;

  repeat
    if einzelschritt then einzelstep;   {neu eingefgt gem c't 4/90,
                                         Erg + Ber }
    for seite:=0 to (seitenzahl-1) do
    begin
      if not batch then gotoxy(1,14);
      gotoxy(1,wherey);
      write('Kopf : ',seite,'  Zylinder : ',spur);
      fehler:=spurformat(spur, seite, 1, sekzahl, drive);
      if fehler=3 then
      begin
        if not batch then gotoxy(1,13);
        writeln; write('Diskette ist schreibgeschtzt !');
        taste:=readkey;
        ausgang(sekzahl);
        exit;
      end;
      if verifyflag then
        fehler:=readwriteverify(4, spur, seite, 1,
                                sekzahl, drive, puffer[1]^);
      if fehler<>0 then
      begin
        if not batch then gotoxy(1,13);
        writeln;
        write('Diskette fr dieses Format unbrauchbar !');
        if not batch then taste:=readkey;
        ausgang(sekzahl);
        if not batch then exit
        else halt(1); {Programm mit Fehlermeldung abbrechen}
      end;
      if keypressed then taste:=readkey;
    end;
    inc(spur);   {Nchste Spur}
  until (taste=#27) or (spur>=spurzahl);
  diskprep(sekzahl, anzsektor);
  ausgang(sekzahl);
  if taste<>#27 then
  begin
    if not batch then
    begin
      gotoxy(1,14);
      write('Diskette wurde fehlerfrei formatiert, ');
      write('weiter mit beliebiger Taste');
      taste:=readkey;
    end;
  end;
end;
{***********************Hauptprogramm************************}
begin
  checkbreak:=false;
  {kein Abbruch des Programms mit CRTL-BREAK}
  drive:=0; verifyflag:=true; {Laufwerk A, Verify : ON}
  art:=laufwerka;  {Art des Laufwerkes s. Unit Formunit}
  fparam:=false;
  if paramcount=0 then
    batch:=false   {Keine Kommandozeile}
  else
    batch:=true;   {Mit Kommandozeile aufgerufen}
  if batch then
  begin
    laufwerk:=paramstr(1);  {Laufwerk holen}
    drive:=ord(upcase(laufwerk[1]))-65;
    {0 oder 1 fr A oder B}
    if (drive>1) or (drive<0) then
    begin
      batch:=false;  {Batchbetrieb abbrechen}
      fparam:=true;  {Falsche Parameter}
      drive:=0;      {Wieder Laufwerk A}
    end;
    if drive=0 then art:=laufwerka else art:=laufwerkb;
    formart:=paramstr(2);   {Gewhlte Formatkapazitt}
    val(formart, artform, code);
    if (code<>0) or (artform<>360) and (artform<>720) and
       (artform<>1200) and (artform<>1440) then
    begin
      batch:=false;
      fparam:=true;
    end;
    verify:=paramstr(3); {Verify OFF bei Wert in Kommandozeile}
    if verify='' then verifyflag:=true else verifyflag:=false;
  end;
  case artform of
    360  : wahl:=1;
    720  : wahl:=2;
    1200 : wahl:=3;
    1440 : wahl:=4;
  end;
  taste:=chr(wahl+48);
  repeat
    if not batch then
    begin
      clrscr;
      gotoxy(50,1); write('(L)aufwerk : ');
      if drive=0 then
      begin
        write('A'); art:=laufwerka;
      end
      else
      begin
        write('B'); art:=laufwerkb;
      end;
      gotoxy(50,2); write('(V)erify   : ');
      if verifyflag then write('ON ') else write('OFF');
      if fparam then {Fehler bei Parametereingabe}
      begin
        gotoxy(1,20);
        writeln('Fehler bei der Parametereingabe !');
        write('Korrekter Aufruf mit ');
        writeln('"Format Laufwerk Formatwahl [n]"');
        write('Laufwerk A oder B, ');
        writeln('Formatwahl 360, 720, 1200 oder 1440');
        writeln('Bei Eingabe von n kein Verify');
      end;
      gotoxy(1,1);
      writeln('    Formatauswahl:');writeln;
      writeln('1.  360  KB auf 5,25-Laufwerk');
      writeln('2.  720  KB auf 5,25- und 3,5-Laufwerk');
      writeln('3.  1,2  MB auf 5,25-Laufwerk');
      writeln('4.  1,44 MB auf 3,5-Laufwerk');writeln;
      writeln('Bitte gewnschte Nummer eingeben ? ');writeln;
      taste:=readkey;
      taste:=upcase(taste);
      wahl:=ord(taste)-48;  {Wahl des Diskettenformates}
    end;
    case taste of
      '1' : diskformat(wahl, 40, 9);
      {Format, Spurzahl, Sekzahl, 360 KB}
      '2' : diskformat(wahl, 80, 9);  {720 KB}
      '3' : diskformat(wahl, 80, 15); {1,2 MB}
      '4' : diskformat(wahl, 80, 18); {1,44 MB}
      'V' : if verifyflag then
              verifyflag:=false else verifyflag:=true;
      'L' : if (drive=0) and (laufwerkb<>0) then
                drive:=1 else drive:=0;
    end;
  until (taste=#27) or batch;
  clrscr;
  {Programmende durch ESC oder Batch}
end.
